package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.a3.action.http.HttpStatus;

/**
 * @author eoshch
 */
public class LegacyResourceLockedException extends LegacyMpfsException {
    // uid of user that owns blocked resource
    private final DjfsUid uid;

    // path of user that made the request
    private final DjfsResourcePath path;

    private final Option<String> operationId;
    private final Option<String> operationType;

    public LegacyResourceLockedException(DjfsUid uid, DjfsResourcePath path, DjfsException cause) {
        this(uid, path, Option.empty(), Option.empty(), cause);
    }

    public LegacyResourceLockedException(DjfsUid uid, DjfsResourcePath path, Option<String> operationId,
            Option<String> operationType, DjfsException cause)
    {
        super(cause);
        this.uid = uid;
        this.path = path;
        this.operationId = operationId;
        this.operationType = operationType;
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.LOCKED;
    }

    @Override
    public int getCode() {
        return 105;
    }

    @Override
    public String getTitle() {
        return "resource is locked";
    }

    @Override
    public String getPythonClassName() {
        return "ResourceLocked";
    }

    @Override
    public Option<MapF<String, String>> getAdditionalData() {
        MapF<String, String> result = Cf.hashMap();

        result.put("uid", uid.asString());
        result.put("path", path.getPath());

        if (operationId.isPresent()) {
            result.put("oid", operationId.get());
        }

        if (operationType.isPresent()) {
            result.put("op_type", operationType.get());
        }

        return Option.of(result);
    }
}
