package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class LegacyResourceNotFoundException extends LegacyMpfsException {
    public LegacyResourceNotFoundException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.NOT_FOUND;
    }

    @Override
    public int getCode() {
        return 71;
    }

    @Override
    public String getPythonClassName() {
        return "ResourceNotFound";
    }

    @Override
    public String getTitle() {
        return "resource not found";
    }
}
