package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;


public class LegacyServiceNotFoundException extends LegacyMpfsException {
    public LegacyServiceNotFoundException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.NOT_FOUND;
    }

    @Override
    public int getCode() {
        return 48;
    }

    @Override
    public String getTitle() {
        return "Service not found";
    }

    @Override
    public String getPythonClassName() {
        return "ServiceNotFound";
    }
}
