package ru.yandex.chemodan.app.djfs.core.legacy.exception;


import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class LegacyStorageAddressError extends LegacyMpfsException {
    public LegacyStorageAddressError(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.CONFLICT;
    }

    @Override
    public int getCode() {
        return 104;
    }

    @Override
    public String getTitle() {
        return "cannot modify storage address";
    }

    @Override
    public String getPythonClassName() {
        return "StorageAddressError";
    }
}
