package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class LegacyTooManyExecutingOperationException extends LegacyMpfsException {
    public LegacyTooManyExecutingOperationException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.TOO_MANY_REQUESTS;
    }

    @Override
    public int getCode() {
        return 250;
    }

    @Override
    public String getTitle() {
        return "too many executing operations";
    }

    @Override
    public String getPythonClassName() {
        return "TooManyExecutingOperationsError";
    }
}
