package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

/**
 * @author eoshch
 */
public class LegacyUserIsReadOnlyException extends LegacyMpfsException {
    public LegacyUserIsReadOnlyException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.LOCKED;
    }

    @Override
    public int getCode() {
        return 150;
    }

    @Override
    public String getTitle() {
        return "user is read-only";
    }

    @Override
    public String getPythonClassName() {
        return "UserIsReadOnly";
    }
}
