package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

/**
 * @author eoshch
 */
public class LegacyWhUserNotInitializedException extends LegacyMpfsException {
    public LegacyWhUserNotInitializedException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.BAD_REQUEST;
    }

    @Override
    public int getCode() {
        return 44;
    }

    @Override
    public String getTitle() {
        return "WH: user is not initialized";
    }

    @Override
    public String getPythonClassName() {
        return "StorageInitUser";
    }
}
