package ru.yandex.chemodan.app.djfs.core.legacy.exception.albums;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.legacy.exception.LegacyMpfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;


public class LegacyAlbumUnableToAppendException extends LegacyMpfsException {
    public final Option<MapF<String, String>> data;

    public LegacyAlbumUnableToAppendException(DjfsException cause) {
        super(cause);
        this.data = Option.empty();
    }

    public LegacyAlbumUnableToAppendException(DjfsException cause, Option<MapF<String, String>> data) {
        super(cause);
        this.data = data;
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.NOT_FOUND;
    }

    @Override
    public int getCode() {
        return 163;
    }

    @Override
    public String getTitle() {
        return "Unable to append item";
    }

    @Override
    public String getPythonClassName() {
        return "AlbumsUnableToAppendItem";
    }

    @Override
    public Option<MapF<String, String>> getAdditionalData() {
        return data;
    }
}

