package ru.yandex.chemodan.app.djfs.core.legacy.exception.albums;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.legacy.exception.LegacyMpfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;


public class LegacyAlbumUnableToDeleteException extends LegacyMpfsException {
    public final Option<MapF<String, String>> data;

    public LegacyAlbumUnableToDeleteException(DjfsException cause) {
        super(cause);
        this.data = Option.empty();
    }

    public LegacyAlbumUnableToDeleteException(DjfsException cause, Option<MapF<String, String>> data) {
        super(cause);
        this.data = data;
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.FORBIDDEN;
    }

    @Override
    public int getCode() {
        return 290;
    }

    @Override
    public String getTitle() {
        return "Album can not be deleted";
    }

    @Override
    public String getPythonClassName() {
        return "DiskAlbumUnableToDelete";
    }

    @Override
    public Option<MapF<String, String>> getAdditionalData() {
        return data;
    }
}
