package ru.yandex.chemodan.app.djfs.core.legacy.exception.mkdir;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.legacy.exception.LegacyMpfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

/**
 * @author eoshch
 */
public class LegacyMkdirNoParentFolderException extends LegacyMpfsException {
    public LegacyMkdirNoParentFolderException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.CONFLICT;
    }

    @Override
    public int getCode() {
        return 9;
    }

    @Override
    public String getTitle() {
        return "mkdir: parent folder was not found";
    }

    @Override
    public String getPythonClassName() {
        return "MkdirNotFound";
    }
}
