package ru.yandex.chemodan.app.djfs.core.legacy.exception.mkdir;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.legacy.exception.LegacyMpfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

/**
 * @author eoshch
 */
public class LegacyMkdirResourceExistsException extends LegacyMpfsException {
    public final Option<DjfsResourcePath> availablePath;

    public LegacyMkdirResourceExistsException(DjfsException cause) {
        this(Option.empty(), cause);
    }

    public LegacyMkdirResourceExistsException(Option<DjfsResourcePath> availablePath, DjfsException cause) {
        super(cause);
        this.availablePath = availablePath;
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.METHOD_NOT_ALLOWED;
    }

    @Override
    public int getCode() {
        return 13;
    }

    @Override
    public String getTitle() {
        return "mkdir: resource already exists";
    }

    @Override
    public Option<MapF<String, String>> getAdditionalData() {
        return availablePath.map(x -> Cf.map("autosuffix_path", x.getPath()));
    }

    @Override
    public String getPythonClassName() {
        return "MkdirFolderAlreadyExist";
    }
}
