package ru.yandex.chemodan.app.djfs.core.legacy.exception.move;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.legacy.exception.LegacyMpfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class LegacyMoveNoTargetParentException extends LegacyMpfsException {
    public LegacyMoveNoTargetParentException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.CONFLICT;
    }

    @Override
    public int getCode() {
        return 62;
    }

    @Override
    public String getTitle() {
        return "Target parent not found";
    }

    @Override
    public String getPythonClassName() {
        return "CopyParentNotFound";
    }
}
