package ru.yandex.chemodan.app.djfs.core.legacy.exception.move;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.legacy.exception.LegacyMpfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class LegacyMoveParentToChildException extends LegacyMpfsException {
    public LegacyMoveParentToChildException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.CONFLICT;
    }

    @Override
    public int getCode() {
        return 122;
    }

    @Override
    public String getTitle() {
        return "move: can't move parent to child";
    }

    @Override
    public String getPythonClassName() {
        return "MoveParentToChild";
    }
}
