package ru.yandex.chemodan.app.djfs.core.legacy.exception.move;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.legacy.exception.LegacyMpfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class LegacyMoveSameDestinationException extends LegacyMpfsException {
    public LegacyMoveSameDestinationException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.CONFLICT;
    }

    @Override
    public int getCode() {
        return 52;
    }

    @Override
    public String getTitle() {
        return "move: same source as target";
    }

    @Override
    public String getPythonClassName() {
        return "MoveSame";
    }
}
