package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.blackbox2.protocol.request.params.EmailsParameterValue;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxAttributes;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDbFields;
import ru.yandex.misc.cache.tl.TlCache;
import ru.yandex.misc.net.LocalhostUtils;

public class BlackboxUtils {

    public static BlackboxCorrectResponse getBlackboxUserInfo(DjfsUid uid, Blackbox2 blackbox) {
        return TlCache.getOrElseUpdate("blackbox userinfo " + uid.asString(),
                () -> blackbox.query().userInfo(
                        LocalhostUtils.localAddress(),
                        Option.of(uid.asPassportUid()),
                        Option.empty(), Option.empty(),
                        Cf.list(
                                BlackboxDbFields.COUNTRY,
                                BlackboxDbFields.FIRSTNAME,
                                BlackboxDbFields.LANG,
                                BlackboxDbFields.LASTNAME
                        ),
                        Cf.list(BlackboxAttributes.IS_2FA_ENABLED, BlackboxAttributes.ACCOUNT_IS_AVAILABLE),
                        Option.of(EmailsParameterValue.GET_ALL),
                        Option.empty(),
                        true,
                        Option.empty(),
                        false,
                        true
                )
        );
    }

    public static <E extends DjfsException> void checkAvailable(DjfsUid uid, Blackbox2 blackbox, Function0<E> e)
    {
        final BlackboxCorrectResponse userInfo = getBlackboxUserInfo(uid, blackbox);
        final boolean available =
                userInfo.getUid().isPresent()
                        && userInfo.getAttributes().getO(BlackboxAttributes.ACCOUNT_IS_AVAILABLE).isSome("1");
        if (!available) {
            throw e.apply();
        }
    }

    public static boolean is2FAEnabled(DjfsUid uid, Blackbox2 blackbox) {
        final BlackboxCorrectResponse userInfo = getBlackboxUserInfo(uid, blackbox);
        return userInfo.getAttributes().getO(BlackboxAttributes.IS_2FA_ENABLED).isSome("1");
    }

    public static Option<String> getCountry(DjfsUid uid, Blackbox2 blackbox) {
        final BlackboxCorrectResponse userInfo = getBlackboxUserInfo(uid, blackbox);
        return userInfo.getDbFields().getO(BlackboxDbFields.COUNTRY);
    }
}
