package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import lombok.Value;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.bender.annotation.BenderPart;

@Bendable
@BenderBindAllFields
@Value
public class Blockings {

    private final Option<MapF<String, Long>> simple;
    private final Option<MapF<String, Long>> video;
    private final Option<MapF<String, Long>> folder;
    @BenderPart(name = "public", strictName = true)
    private final Option<Boolean> isPublic;
    @BenderIgnore
    private final String hid;

    public Blockings merge(Blockings toMergeWith) {
        return new Blockings(toMergeWith.simple.orElse(simple),
                toMergeWith.video.orElse(video),
                toMergeWith.folder.orElse(folder),
                toMergeWith.isPublic.orElse(isPublic),
                hid);
    }
}
