package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import java.net.URI;
import java.util.function.Supplier;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.AntiVirusScanStatus;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FileDjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.MediaType;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.PhotosliceAlbumType;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.VersioningStatus;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.chemodan.app.djfs.core.util.InstantUtils;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;


@Bendable
@BenderBindAllFields
public class FileMetaPojo extends ResourceMetaPojo {

    public final Option<Integer> drweb;
    public final Option<Long> etime;
    public final Option<Long> size;

    public final Option<ListF<PreviewInfo>> sizes;
    @BenderPart(name = "custom_preview", strictName = true)
    public final Option<String> customPreview;

    @BenderPart(name = "file_url", strictName = true)
    public final Option<String> fileUrl;

    @BenderPart(name = "mediatype", strictName = true)
    public final Option<String> mediaType;
    @BenderPart(name = "media_type", strictName = true)
    public final Option<String> media_type;

    @BenderPart(name = "mimetype", strictName = true)
    public final Option<String> mimeType;

    @BenderPart(name = "storage_type", strictName = true)
    public final Option<String> storageType;

    @BenderPart(name = "photoslice_time", strictName = true)
    public final Option<Long> photosliceTime;

    @BenderPart(name = "photoslice_album_type", strictName = true)
    public final Option<String> photosliceAlbumType;

    @BenderPart(name = "versioning_status", strictName = true)
    public final Option<String> versioningStatus;

    @BenderPart(name = "fotki_data_stid", strictName = true)
    public final Option<String> fotkiDataStid;

    @BenderPart(name = "fotki_data_url", strictName = true)
    public final Option<String> fotkiDataUrl;

    @BenderPart(name = "video_info", strictName = true)
    public final Option<JsonValue> videoInfo;

    @BenderPart(name = "note_name", strictName = true)
    public final Option<String> noteName;
    @BenderPart(name = "note_revision_created", strictName = true)
    public final Option<String> noteRevisionCreated;
    @BenderPart(name = "note_revision_deleted", strictName = true)
    public final Option<String> noteRevisionDeleted;
    @BenderPart(name = "file_mid", strictName = true)
    public final Option<String> fileMid;
    @BenderPart(name = "md5", strictName = true)
    public final Option<String> md5;
    @BenderPart(name = "sha256", strictName = true)
    public final Option<String> sha256;
    @BenderPart(name = "aesthetics", strictName = true)
    public final Option<Double> aesthetics;
    @BenderPart(name = "width", strictName = true)
    public final Option<Integer> width;
    @BenderPart(name = "height", strictName = true)
    public final Option<Integer> height;
    @BenderPart(name = "angle", strictName = true)
    public final Option<Integer> angle;
    @BenderPart(name = "albums_exclusions", strictName = true)
    public final Option<ListF<String>> albumsExclusions;
    @BenderPart(name = "pmid", strictName = true)
    public final Option<String> pmid;
    @BenderPart(name = "office_online_url", strictName = true)
    public final Option<String> officeOnlineUrl;
    @BenderPart(name = "office_online_editor_type", strictName = true)
    public final Option<String> officeOnlineEditorType;
    @BenderPart(name = "digest_mid", strictName = true)
    public final Option<String> digestMid;
    @BenderPart(name = "digest_url", strictName = true)
    public final Option<String> digestUrl;
    @BenderPart(name = "fotki_image_id", strictName = true)
    public final Option<String> fotkiImageId;

    public final Option<String> hid;


    //autouploaded field skipped, see https://st.yandex-team.ru/CHEMODAN-67538#5dadbfca29af1d001da5c701


    public FileMetaPojo(FileMetaProvider metaProvider, FileDjfsResource file, Supplier<Option<ShareInfo>> shareInfoProvider,
            FormattingContext context)
    {
        super(metaProvider, file, shareInfoProvider, context);

        fileUrl = metaProvider.getFileUrl(file, shareInfoProvider, context).map(URI::toString);
        drweb = metaProvider.getDrweb(file, context).map(AntiVirusScanStatus::value);
        etime = metaProvider.getEtime(file);
        mediaType = metaProvider.getMediaType(file, context).map(MediaType::getStringRepresentation);
        media_type = metaProvider.getMedia_type(file, context).map(MediaType::getStringRepresentation);
        mimeType = metaProvider.getMimeType(file, context);
        size = metaProvider.getSize(file, context);
        storageType = metaProvider.getStorageType(file, context);
        photosliceTime = metaProvider.getPhotosliceTime(file, context).map(InstantUtils::toSecondsLong);
        photosliceAlbumType = metaProvider.getPhotosliceAlbumType(file, context).map(PhotosliceAlbumType::value);
        this.versioningStatus = metaProvider.getVersioningStatus(file, context)
                .filter(vs -> !vs.equals(VersioningStatus.DISABLED))
                .map(VersioningStatus::value);
        videoInfo = metaProvider.getVideoInfo(file, context);
        fotkiDataStid = metaProvider.getFotkiDataStid(file, context);
        fotkiDataUrl = metaProvider.getFotkiDataUrl(file, shareInfoProvider, context).map(URI::toString);
        noteName = metaProvider.getNoteName(file, context);
        noteRevisionCreated = metaProvider.getNoteRevisionCreated(file, context);
        noteRevisionDeleted = metaProvider.getNoteRevisionDeleted(file, context);
        fileMid = metaProvider.getFileMid(file, context);
        md5 = metaProvider.getMd5(file, context);
        sha256 = metaProvider.getSha256(file, context);
        aesthetics = metaProvider.getAesthetics(file, context);
        height = metaProvider.getHeight(file, context);
        width = metaProvider.getWidth(file, context);
        angle = metaProvider.getAngle(file, context);
        albumsExclusions = metaProvider.getAlbumsExclusions(file, context);
        pmid = metaProvider.getPmid(file, context);

        customPreview = metaProvider.getCustomPreview(file, shareInfoProvider, context).map(URI::toString);
        Option<MapF<MetaPreviewUrlSize, URI>> previews = metaProvider.getPreviewSizes(file, shareInfoProvider, context);
        if (previews.isPresent()) {
            MapF<MetaPreviewUrlSize, URI> previewsSizes = previews.get();
            ListF<PreviewInfo> result = Cf.arrayList();
            for (Tuple2<MetaPreviewUrlSize, URI> previewSize : previewsSizes.entries()) {
                result.add(new PreviewInfo(previewSize.get1().value(), previewSize.get2().toString()));
            }
            sizes = Option.of(result);
        } else {
            sizes = Option.empty();
        }
        Option<OnlineOfficeData> onlineOfficeDataO = metaProvider.getOnlineOfficeData(file, context);
        officeOnlineUrl = onlineOfficeDataO.flatMapO(OnlineOfficeData::getOfficeOnlineUrl);
        officeOnlineEditorType = onlineOfficeDataO.flatMapO(OnlineOfficeData::getOfficeOnlineEditorType);
        digestMid = metaProvider.getDigestMid(file, context);
        digestUrl = metaProvider.getDigestUrl(file, shareInfoProvider, context).map(URI::toString);
        fotkiImageId = metaProvider.getExternalProperty(file, context, "fotki_image_id");
        hid = metaProvider.getHid(file, context);
    }

    @Data
    public static class OnlineOfficeData {

        public static OnlineOfficeData fromMetaProviderMap(MapF<String, String> data) {
            return new OnlineOfficeData(
                    data.getO(FileMetaProvider.ONLINE_OFFICE_URL),
                    data.getO(FileMetaProvider.OFFICE_ONLINE_EDITOR_TYPE)
            );
        }

        private final Option<String> officeOnlineUrl;

        private final Option<String> officeOnlineEditorType;

    }
}
