package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import java.util.function.Supplier;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FileDjfsResource;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@Bendable
@BenderBindAllFields
public class FilePojo extends ResourcePojo {
    public final Option<FileMetaPojo> meta;
    public final Option<Long> etime;

    public FilePojo(FileDjfsResource file, Supplier<Option<ShareInfo>> shareInfoProvider,
            Option<FileMetaPojo> meta, FormattingContext context)
    {
        super("file", file, shareInfoProvider, context);
        this.meta = meta;
        this.etime = file.getEtime();
    }
}
