package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import java.util.function.Supplier;

import lombok.Data;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderDjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderType;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;


@Bendable
@BenderBindAllFields
public class FolderMetaPojo extends ResourceMetaPojo {
    @BenderPart(name = "folder_type", strictName = true)
    public final Option<String> folderType;
    @BenderPart(name = "numchildren", strictName = true)
    public final Option<Long> numChildren;
    @BenderPart(name = "empty", strictName = true)
    public final Option<Integer> empty;
    @BenderPart(name = "alias_enabled", strictName = true)
    public final Option<String> aliasEnabled;
    @BenderPart(name = "hasfolders", strictName = true)
    public final Option<Integer> hasFolders;
    @BenderPart(name = FolderMetaProvider.WITH_SHARED, strictName = true)
    public final Option<Integer> withShared;
    @BenderPart(name = FolderMetaProvider.SHARED_RIGHTS, strictName = true)
    public final Option<SharedRights> sharedRights;


    public FolderMetaPojo(FolderMetaProvider metaProvider, FolderDjfsResource folder,
                          Supplier<Option<ShareInfo>> shareInfoProvider, FormattingContext context)
    {
        super(metaProvider, folder, shareInfoProvider, context);
        folderType = metaProvider.getFolderType(folder, context).map(FolderType::value);
        numChildren = metaProvider.getNumChildren(folder, context);
        empty = metaProvider.isEmpty(folder, context).map(x -> x ? 1 : 0);
        aliasEnabled = metaProvider.getAliasEnabled(folder, context);
        hasFolders = metaProvider.hasFolders(folder, context);
        Option<FolderSharedMeta> sharedMetaO = metaProvider.getFolderSharedMeta(folder, context);
        withShared = sharedMetaO.flatMapO(FolderSharedMeta::getWithShared);
        sharedRights = sharedMetaO.flatMapO(FolderSharedMeta::getSharedRights);
    }

    @Data
    public static class FolderSharedMeta {

         public static FolderSharedMeta fromMetaProviderMap(MapF<String, Object> data) {
             return new FolderSharedMeta(
                     data.getO(FolderMetaProvider.WITH_SHARED).filter(Integer.class::isInstance).map(Integer.class::cast),
                     data.getO(FolderMetaProvider.SHARED_RIGHTS).filter(SharedRights.class::isInstance).map(SharedRights.class::cast)
             );
         }

         private final Option<Integer> withShared;

         private final Option<SharedRights> sharedRights;
    }
}
