package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import com.mongodb.ReadPreference;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.djfs.core.client.LogReaderHttpClient;
import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsResourceDao;
import ru.yandex.chemodan.app.djfs.core.filesystem.Filesystem;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderDjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderType;
import ru.yandex.chemodan.app.djfs.core.publication.PublicationManager;
import ru.yandex.chemodan.app.djfs.core.share.GroupDao;
import ru.yandex.chemodan.app.djfs.core.share.GroupLinkDao;
import ru.yandex.chemodan.app.djfs.core.user.UserData;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

public class FolderMetaProvider extends ResourceMetaProvider {

    public static final String WITH_SHARED = "with_shared";

    public static final String SHARED_RIGHTS = "shared_rights";

    private static final SetF<ReadResourceEndpoint> NUMCHILDREN_AVAILABLE_ENDPOINTS = Cf.set(ReadResourceEndpoint.INFO,
            ReadResourceEndpoint.LIST);

    private final DjfsResourceDao djfsResourceDao;

    private final GroupDao groupDao;

    private final GroupLinkDao groupLinkDao;

    public FolderMetaProvider(Filesystem filesystem, Blackbox2 blackbox, PublicationManager publicationManager,
            LogReaderHttpClient logReaderHttpClient, DjfsResourceDao djfsResourceDao, GroupDao groupDao,
                              GroupLinkDao groupLinkDao)
    {
        super(filesystem, blackbox, logReaderHttpClient, publicationManager);
        this.djfsResourceDao = djfsResourceDao;
        this.groupDao = groupDao;
        this.groupLinkDao = groupLinkDao;
    }

    Option<FolderType> getFolderType(FolderDjfsResource folder, FormattingContext context) {
        return getMetaField(context, "folder_type", folder::getFolderType);
    }

    Option<Long> getNumChildren(FolderDjfsResource folder, FormattingContext context) {
        //only if requested
        if (context.getRequestMetaFields().isPresent() &&
                context.getRequestMetaFields().get().containsTs("numchildren")
                && NUMCHILDREN_AVAILABLE_ENDPOINTS.containsTs(context.getReadResourceEndpoint()))
        {
            return folder.getPath().getArea().getFolderAreaMetaProvider()
                    .getNumchildren(folder, djfsResourceDao);
        }

        return Option.empty();
    }

    //only if exists meta and resource area is trash
    Option<Boolean> isEmpty(FolderDjfsResource folder, FormattingContext context) {
        return getMetaFieldOnlyWithIntent(context, "empty",
                () -> isEmptyFolderInTrash(context.getRequestUser(), folder, Option.of(context.getReadResourceEndpoint().getReadPreference())));
    }

    Option<String> getAliasEnabled(FolderDjfsResource folder, FormattingContext context) {
        return getMetaField(context, "alias_enabled", () -> folder.getExternalProperties().getO("alias_enabled"));
    }

    Option<Integer> hasFolders(FolderDjfsResource folder, FormattingContext context) {
        // VALID ONLY FOR BULK_INFO. TODO IMPLEMENT IF NEEDED FOR LIST
        return getMetaField(context, "hasfolders", () -> Option.of(0));
    }

    public Option<FolderMetaPojo.FolderSharedMeta> getFolderSharedMeta(FolderDjfsResource folder, FormattingContext context) {
        return getMetaFields(context, Cf.list(WITH_SHARED, SHARED_RIGHTS),
                () -> folder.getPath().getArea().getFolderAreaMetaProvider()
                        .getFolderSharedMetaData(folder, context, groupDao, groupLinkDao, Option.of(context.getReadResourceEndpoint().getReadPreference())),
                FolderMetaPojo.FolderSharedMeta::fromMetaProviderMap);
    }

    private Option<Boolean> isEmptyFolderInTrash(UserData requestUser, FolderDjfsResource folder, Option<ReadPreference> readPreference) {
        return folder.getPath().getArea().getFolderAreaMetaProvider().getIsEmpty(requestUser, folder, filesystem, readPreference);
    }
}
