package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import java.util.function.Supplier;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderDjfsResource;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@Bendable
@BenderBindAllFields
public class FolderPojo extends ResourcePojo {
    public final Option<FolderMetaPojo> meta;

    public FolderPojo(FolderDjfsResource folder, Supplier<Option<ShareInfo>> shareInfoProvider,
            Option<FolderMetaPojo> meta, FormattingContext context)
    {
        super("dir", folder, shareInfoProvider, context);
        this.meta = meta;
    }

    @Override
    protected String getId(String path) {
        return path.endsWith("/") ? path : path + "/";
    }
}
