package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderDjfsResource;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.chemodan.app.djfs.core.share.SharePermissions;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@Bendable
@BenderBindAllFields
public class GroupInfo {
    public final String gid;

    @BenderPart(name = "is_owned", strictName = true)
    public final Integer isOwned;

    @BenderPart(name = "is_root", strictName = true)
    public final Integer isRoot;

    @BenderPart(name = "is_shared", strictName = true)
    public final Integer isShared = 1;  // mpfs inspired

    public final Option<Integer> rights;

    //user_count field was removed, because of nobody used it

    public final GroupOwner owner;

    public final Option<Long> size;

    public GroupInfo(DjfsUid requestUid, ShareInfo shareInfo, DjfsResource resource, GroupOwner groupOwnerPojo) {
        gid = shareInfo.getGroupId();
        owner = groupOwnerPojo;

        if (resource instanceof FolderDjfsResource && shareInfo.isRoot(resource.getPath())) {
            isRoot = 1;
            size = Option.of(shareInfo.getGroupSize());
        } else {
            isRoot = 0;
            size = Option.empty();
        }

        if (requestUid.equals(shareInfo.getOwnerUid())) {
            isOwned = 1;
            rights = Option.empty();
        } else {
            isOwned = 0;
            rights = shareInfo.getPermissions(requestUid).map(SharePermissions::value);
        }
    }
}
