package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import java.net.IDN;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDbFields;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDisplayName;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.email.Email;

@Bendable
@BenderBindAllFields
public class GroupOwner {
    public final String login;

    @BenderPart(name = "decoded_email", strictName = true)
    public final String decodedEmail;

    @BenderPart(name = "public_name", strictName = true)
    public final String publicName;

    public final String email;

    public final String uid;

    public final String username;

    public GroupOwner(BlackboxCorrectResponse userInfo) {
        login = userInfo.getLogin().getOrElse("");

        Option<Email> emailO = userInfo.getDefaultEmail().plus(userInfo.getEmails().firstO()).firstO();
        if (emailO.isPresent()) {
            email = emailO.get().getEmail();
            String localPart = IDN.toUnicode(emailO.get().getLocalPart());
            String domain = IDN.toUnicode(emailO.get().getDomain().getDomain());
            decodedEmail = localPart + "@" + domain;
        } else {
            email = "";
            decodedEmail = "";
        }
        publicName = userInfo.getDisplayName().map(BlackboxDisplayName::getPublicName)
                .getOrElse(Option::empty).getOrElse("");

        uid = userInfo.getUid().map(PassportUid::toString).getOrNull();

        Option<String> firstName = userInfo.getDbFields().getO(BlackboxDbFields.FIRSTNAME).filterNot(String::isEmpty);
        Option<String> lastName = userInfo.getDbFields().getO(BlackboxDbFields.LASTNAME).filterNot(String::isEmpty);

        username = firstName.isPresent() && lastName.isPresent()
                ? firstName.get() + " " + lastName.get()
                : userInfo.getDisplayName().map(BlackboxDisplayName::getName).getOrElse("");
    }
}
