package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FileDjfsResource;

public enum OnlineOfficeClientType {

    DISK {
        @Override
        public Option<String> getDocumentId(FileDjfsResource file, Option<DjfsResourcePath> visiblePath) {
            return visiblePath.map(DjfsResourcePath::getPath).map(path -> path.replaceAll("^/", ""));
        }
    },
    PUBLIC {
        @Override
        public Option<String> getDocumentId(FileDjfsResource file, Option<DjfsResourcePath> visiblePath) {
            return file.getPublicHash();
        }
    };

    public abstract Option<String> getDocumentId(FileDjfsResource file, Option<DjfsResourcePath> visiblePath);
}
