package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import com.mongodb.ReadPreference;

public enum ReadResourceEndpoint {
    BULK_INFO(true, true, OnlineOfficeClientType.DISK, ReadPreference.secondaryPreferred()),
    BULK_INFO_BY_RESOURCE_IDS(true, true, OnlineOfficeClientType.DISK, ReadPreference.secondaryPreferred()),
    PUBLIC_INFO(false, false, OnlineOfficeClientType.PUBLIC, ReadPreference.secondaryPreferred()),
    PUBLIC_LIST(true, false, OnlineOfficeClientType.PUBLIC, ReadPreference.secondaryPreferred()),
    LIST(true, true, OnlineOfficeClientType.DISK, ReadPreference.secondaryPreferred()),
    INFO(true, true, OnlineOfficeClientType.DISK, ReadPreference.secondaryPreferred()),
    ALBUM_APPEND_ITEMS(true, true, OnlineOfficeClientType.DISK, ReadPreference.secondaryPreferred()),
    ALBUM_SET_ATTR(true, true, OnlineOfficeClientType.DISK, ReadPreference.secondaryPreferred());

    private final boolean includeIdAndPath;
    private final boolean eternalPreview;
    private final OnlineOfficeClientType onlineOfficeClientType;
    private final ReadPreference readPreference;

    ReadResourceEndpoint(boolean includeIdAndPath, boolean eternalPreview, OnlineOfficeClientType onlineOfficeClientType,
                         ReadPreference readPreference) {
        this.includeIdAndPath = includeIdAndPath;
        this.eternalPreview = eternalPreview;
        this.onlineOfficeClientType = onlineOfficeClientType;
        this.readPreference = readPreference;
    }

    public boolean includeIdAndPath() {
        return includeIdAndPath;
    }

    public boolean isEternalPreview() {
        return eternalPreview;
    }

    public OnlineOfficeClientType getOnlineOfficeClientType() {
        return onlineOfficeClientType;
    }

    public ReadPreference getReadPreference() {
        return readPreference;
    }
}
