package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import java.util.function.Supplier;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsFileId;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceId;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.chemodan.app.djfs.core.util.InstantUtils;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;


@Bendable
@BenderBindAllFields
@AllArgsConstructor
public abstract class ResourceMetaPojo {

    public static final String VERSION_DISK_DIST = "version_urn_yandex_disk_dist";

    public static final String CDN_DISK_DIST = "cdn_urn_yandex_disk_dist_url";

    public static final String WIN_32_ATTRIBUTTES = "Win32FileAttributes_urn_schemas-microsoft-com";

    public static final String LINK_CLIENT_META = "link_urn_yandex_disk_client_meta";

    public final Option<GroupInfo> group;

    public final Option<Integer> blocked;

    public final Option<Integer> visible;

    @BenderPart(name = "public", strictName = true)
    public final Option<Integer> isPublic;

    @BenderPart(name = "file_id", strictName = true)
    public final Option<String> fileId;

    @BenderPart(name = "resource_id", strictName = true)
    public final Option<String> resourceId;

    @BenderPart(name = "custom_properties", strictName = true)
    public final Option<JsonValue> customProperties;

    @BenderPart(name = "short_url", strictName = true)
    public final Option<String> shortUrl;

    @BenderPart(name = "download_counter", strictName = true)
    public final Option<Integer> downloadCounter;

    @BenderPart(name = "views_counter", strictName = true)
    public final Option<Long> viewsCounter;

    @BenderPart(name = "page_blocked_items_num", strictName = true)
    public Option<Integer> pageBlockedItemsNum;

    @BenderPart(name = "comment_ids", strictName = true)
    public final Option<CommentId> commentIds;

    public final Option<Blockings> blockings;

    @BenderPart(name = "revision", strictName = true)
    public final Option<Long> revision;
    @BenderPart(name = "public_hash", strictName = true)
    public final Option<String> publicHash;

    @BenderPart(name = "append_time", strictName = true)
    public final Option<Long> trashAppendTime;
    @BenderPart(name = "original_id", strictName = true)
    public final Option<String> pathBeforeRemoved;

    @BenderPart(name = "original_parent_id", strictName = true)
    public final Option<String> originalParentId;

    @BenderPart(name = "fs_symbolic_link", strictName = true)
    public final Option<String> fsSymbolicLink;

    @BenderPart(name = VERSION_DISK_DIST, strictName = true)
    public final Option<String> versionDiskDist;

    @BenderPart(name = CDN_DISK_DIST, strictName = true)
    public final Option<String> cdnDiskDist;
    @BenderPart(name = WIN_32_ATTRIBUTTES, strictName = true)
    public final Option<String> win32Attributes;
    @BenderPart(name = LINK_CLIENT_META, strictName = true)
    public final Option<String> linkClientMeta;



    public ResourceMetaPojo(ResourceMetaProvider metaProvider, DjfsResource resource, Supplier<Option<ShareInfo>> shareInfoProvider,
            FormattingContext context)
    {
        blocked = metaProvider.isBlocked(resource, context).filter(x -> x).map(x -> 1);
        visible = metaProvider.isVisible(resource, context).map(x -> x ? 1 : 0);
        isPublic = metaProvider.isPublic(resource, context).filter(x -> x).map(x -> 1);
        fileId = metaProvider.getFileId(resource, context).map(DjfsFileId::getValue);
        resourceId = metaProvider.getResourceId(resource, context).map(DjfsResourceId::getValue);
        customProperties = metaProvider.getCustomProperties(resource, context);
        shortUrl = metaProvider.getShortUrl(resource, context);
        group = metaProvider.getGroupInfo(resource, shareInfoProvider, context);
        downloadCounter = metaProvider.getDownloadCounter(resource, context);
        viewsCounter = metaProvider.getViewsCounter(resource, context);
        pageBlockedItemsNum = metaProvider.getPageBlockedItemsNum(resource, context);
        commentIds = metaProvider.getCommentIds(resource, context);
        blockings = metaProvider.getBlockings(resource, context);
        revision = metaProvider.getRevision(resource, context);
        publicHash = metaProvider.getPublicHash(resource, context);
        trashAppendTime = metaProvider.getTrashAppendTime(resource, context).map(InstantUtils::toSecondsLong);
        pathBeforeRemoved = metaProvider.getPathBeforeRemoved(resource, context);
        originalParentId = metaProvider.getOriginalParenId(resource, context);
        fsSymbolicLink = metaProvider.getFsSymbolicLink(resource, context);
        versionDiskDist = metaProvider.getExternalProperty(resource, context, ResourceMetaProvider.VERSION_DISK_DIST);
        cdnDiskDist = metaProvider.getExternalProperty(resource, context, ResourceMetaProvider.CDN_DISK_DIST);
        win32Attributes = metaProvider.getExternalProperty(resource, context, ResourceMetaProvider.WIN_32_ATTRIBUTTES);
        linkClientMeta = metaProvider.getExternalProperty(resource, context, ResourceMetaProvider.LINK_CLIENT_META);
    }
}
