package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.bender.DelegatedBenderJsonWriter;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;

public class ResourceMetaPojoBenderJsonWriter extends DelegatedBenderJsonWriter {

    private static final MapF<String, String> CUSTOM_FIELDS = Cf.map(ResourceMetaPojo.VERSION_DISK_DIST, ResourceMetaProvider.VERSION_DISK_DIST,
            ResourceMetaPojo.CDN_DISK_DIST, ResourceMetaProvider.CDN_DISK_DIST,
            ResourceMetaPojo.WIN_32_ATTRIBUTTES, ResourceMetaProvider.WIN_32_ATTRIBUTTES,
            ResourceMetaPojo.LINK_CLIENT_META, ResourceMetaProvider.LINK_CLIENT_META);

    public ResourceMetaPojoBenderJsonWriter(BenderJsonWriter writer) {
        super(writer);
    }

    @Override
    public void writeFieldName(String name) {
        Option<String> customNameO = CUSTOM_FIELDS.getO(name);
        if (customNameO.isPresent()) {
            super.writeFieldName(customNameO.get());
            return;
        }
        super.writeFieldName(name);
    }
}
