package ru.yandex.chemodan.app.djfs.core.legacy.formatting;


import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.misc.bender.Format;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactory;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingJsonCallback;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingXmlCallback;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.EmptyPojoMarshallingJsonCallback;
import ru.yandex.misc.bender.serialize.MainMarshallerFactory;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.bender.serialize.ToFieldWithCallbackMarshaller;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.TypeX;
import ru.yandex.misc.xml.stream.XmlWriter;

public class ResourceMetaPojoMarshaller extends ToFieldMarshallerSupport implements ToFieldWithCallbackMarshaller {

    public static ResourceMetaPojoMarshaller createMarshaller(CustomMarshallerUnmarshallerFactory marshallerUnmarshallerFactory, Class<? extends ResourceMetaPojo> klass) {
        BenderConfiguration benderConfiguration = new BenderConfiguration(BenderConfiguration.defaultSettings(), marshallerUnmarshallerFactory);
        MainMarshallerFactory mainMarshallerFactory = new MainMarshallerFactory(Format.JSON, benderConfiguration);
        return new ResourceMetaPojoMarshaller((ToFieldWithCallbackMarshaller) mainMarshallerFactory.createMarshaller(TypeX.wrap(ClassX.wrap(klass))));
    }

    private final ToFieldWithCallbackMarshaller marshaller;

    private ResourceMetaPojoMarshaller(ToFieldWithCallbackMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public void writeJsonToFieldWithCallback(BenderJsonWriter writer, Object fieldValue, PojoMarshallingJsonCallback callback, MarshallerContext context) {
        ResourceMetaPojoBenderJsonWriter customWriter = new ResourceMetaPojoBenderJsonWriter(writer);
        marshaller.writeJsonToFieldWithCallback(customWriter, fieldValue, callback, context);
    }

    @Override
    public void writeXmlToFieldWithCallback(XmlWriter writer, Object fieldValue, PojoMarshallingXmlCallback callback,
                                            MarshallerContext context) {
        throw new NotImplementedException();
    }

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        writeJsonToFieldWithCallback(writer, fieldValue, new EmptyPojoMarshallingJsonCallback(), context);
    }
}
