package ru.yandex.chemodan.app.djfs.core.legacy.formatting;


import java.util.function.Supplier;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.chemodan.app.djfs.core.util.InstantUtils;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderParseSubclasses;
import ru.yandex.misc.bender.annotation.SubclassTypeDefinition;

@Bendable
@BenderBindAllFields
@BenderParseSubclasses(
        value = {
                FilePojo.class,
                FolderPojo.class
        },
        typeDefinition = SubclassTypeDefinition.FIELD)
public abstract class ResourcePojo {
    //legacy logic from mpfs
    private static final Long DEFAULT_CREATION_DATE_FOR_AREAS = 1333569600L;

    public String type;
    public final String name;
    public final Option<String> id;
    public final Option<String> path;
    public final Option<Long> ctime;
    public final Option<Long> mtime;
    public final Option<Long> utime;

    public ResourcePojo(String type, DjfsResource resource, Supplier<Option<ShareInfo>> shareInfoProvider, FormattingContext context) {
        name = sanitizeName(resource.getDisplayName());
        this.type = type;

        path = Option.when(context.getReadResourceEndpoint().includeIdAndPath(), () -> resource.getPath().getArea()
                .getOutputPathForResource(resource, context.getRequestUser().getId(), shareInfoProvider).getPath());
        Option<Instant> actualTime = resource.getCreationTimeO().orElse(resource.getModificationTimeO());

        id = Option.when(context.getReadResourceEndpoint().includeIdAndPath(), () -> getId(path.get()));
        ctime = getOrDefaultAreaDate(
                resource,
                resource.getCreationTimeO().orElse(actualTime).map(InstantUtils::toSecondsHalfDown));
        mtime = getOrDefaultAreaDate(
                resource,
                resource.getModificationTimeO().orElse(actualTime).map(InstantUtils::toSecondsHalfDown));
        utime = resource.getUploadTime().orElse(actualTime).map(InstantUtils::toSecondsHalfDown)
                .orElse(Option.of(0L)); //mpfs logic
    }

    protected String getId(String path) {
        return path;
    }

    private static String sanitizeName(String name) {
        return name.replaceAll("[\\x00-\\x08\\x0B-\\x0C\\x0E-\\x1F\\x7F]", " ");
    }

    private static Option<Long> getOrDefaultAreaDate(DjfsResource resource, Option<Long> value) {
        if (resource.getPath().isAreaRoot()) {
            return value.orElse(Option.of(DEFAULT_CREATION_DATE_FOR_AREAS));
        }
        return value;
    }

}

