package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import java.util.function.Supplier;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FileDjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderDjfsResource;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfoManager;
import ru.yandex.chemodan.util.MemoizedSupplier;


@RequiredArgsConstructor
public class ResourcePojoBuilder {
    private final ShareInfoManager shareInfoManager;
    private final FileMetaProvider fileMetaProvider;
    private final FolderMetaProvider folderMetaProvider;

    private FilePojo build(FileDjfsResource file, FormattingContext context)
    {
        Supplier<Option<ShareInfo>> shareInfoProvider = getShareInfoProvider(file, context);
        Option<FileMetaPojo> metaO;
        if (context.getRequestMetaFields().isPresent()) {
            metaO = Option.of(new FileMetaPojo(fileMetaProvider, file, shareInfoProvider, context));
        } else {
            metaO = Option.empty();
        }
        return new FilePojo(file, shareInfoProvider, metaO, context);
    }

    private FolderPojo build(FolderDjfsResource folder, FormattingContext context)
    {
        Supplier<Option<ShareInfo>> shareInfoProvider = getShareInfoProvider(folder, context);
        Option<FolderMetaPojo> metaO;
        if (context.getRequestMetaFields().isPresent()) {
            metaO = Option.of(new FolderMetaPojo(folderMetaProvider, folder, shareInfoProvider, context));
        } else {
            metaO = Option.empty();
        }
        return new FolderPojo(folder, shareInfoProvider, metaO, context);
    }

    private Supplier<Option<ShareInfo>> getShareInfoProvider(DjfsResource resource, FormattingContext context) {
        return MemoizedSupplier.memoize(() -> resource.getPath().getArea().getShareInfoWithRoot(
                resource,
                shareInfoManager,
                Option.of(context.getReadResourceEndpoint().getReadPreference()),
                Option.empty()
        ));
    }

    public ResourcePojo build(DjfsResource resource, FormattingContext context)
    {
        if (resource instanceof FileDjfsResource) {
            return build((FileDjfsResource) resource, context);
        } else if (resource instanceof FolderDjfsResource) {
            return build((FolderDjfsResource) resource, context);
        }
        throw new NotImplementedException();
    }
}
