package ru.yandex.chemodan.app.djfs.core.legacy.formatting;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;

@Bendable
public class SharedRights {

    public static SharedRights withRights(int rights) {
        return new SharedRights(Option.of(rights));
    }

    public static SharedRights owner() {
        return new SharedRights(Option.empty());
    }

    private final Option<Integer> rights;

    private SharedRights(Option<Integer> rights) {
        this.rights = rights;
    }

    public boolean isOwner() {
        return !rights.isPresent();
    }

    public int getRights() {
        return rights.get();
    }
}
