package ru.yandex.chemodan.app.djfs.core.legacy.formatting.office;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

import javax.annotation.PostConstruct;

import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.discovery.MicrosoftApp;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.discovery.XmlWopiDiscovery;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class MicrosoftAppsDiscoveryService {

    private static final Logger logger = LoggerFactory.getLogger(MicrosoftAppsDiscoveryService.class);

    private final HttpClient httpClient;

    private final MicrosoftAppsDiscoveryRegistry microsoftAppsDiscoveryRegistry;

    private DynamicProperty<ListF<String>> appsToCheck = new DynamicProperty<>("disk-djfs-online-office-microsoft-apps",
            Cf.list("Word", "Excel", "PowerPoint", "WopiTest"));

    private DynamicProperty<ListF<String>> actionsToCheck = new DynamicProperty<>("disk-djfs-online-office-microsoft-apps-actions",
            Cf.list("view", "edit", "editnew", "getinfo"));

    private DynamicProperty<String> url = new DynamicProperty<>("disk-djfs-online-office-microsoft-discovery-url",
            "https://onenote.officeapps-df.live.com/hosting/discovery/");

    public MicrosoftAppsDiscoveryService(MicrosoftAppsDiscoveryRegistry microsoftAppsDiscoveryRegistry,
            HttpClient httpClient) {
        this.microsoftAppsDiscoveryRegistry = microsoftAppsDiscoveryRegistry;
        this.httpClient = httpClient;
    }

    @PostConstruct
    public void init() {
        initRegistryData();
    }

    public void initRegistryData() {
        if (!microsoftAppsDiscoveryRegistry.isInitialized()) {
            logger.debug("Is not initalized");
            return;
        }
        if (!microsoftAppsDiscoveryRegistry.getAll().isEmpty()) {
            return;
        }
        try {
            loadApps().forEach(microsoftAppsDiscoveryRegistry::putIfAbsent);
        } catch (Exception e) {
            logger.error("Cannot load Microsoft Apps", e);
        }
    }

    public ListF<MicrosoftApp> loadApps() throws IOException {
        HttpGet request = new HttpGet(url.get());
        return httpClient.execute(request, response -> {
            String content = response.getEntity() == null ? "<no content>" : IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
            int statusCode = response.getStatusLine().getStatusCode();
            logger.info(content);
            if (!HttpStatus.is2xx(statusCode)) {
                throw new HttpException(statusCode, content);
            }
            return MicrosoftApp.fromXml(XmlWopiDiscovery.parser.parseXml(content), appsToCheck.get(), actionsToCheck.get());
        });
    }

    public Option<String> getAvailableAppForEditByExtension(String extension) {
        return microsoftAppsDiscoveryRegistry.getAll().find(app -> app.getActions().find(action -> OnlineOfficeFileEditor.EDIT_ACTION.equals(action.getAction()))
                .filter(action -> action.getExtensionUrls().find(extensionUrl -> extension.equals(extensionUrl.getExtension())).isPresent()).isPresent())
                .map(MicrosoftApp::getApp);
    }

}
