package ru.yandex.chemodan.app.djfs.core.legacy.formatting.office;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FileDjfsResource;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.dao.OfficeAllowedPddDomainDao;
import ru.yandex.chemodan.app.djfs.core.user.Pdd;
import ru.yandex.chemodan.app.djfs.core.user.UserData;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.blackbox2.protocol.response.DomainInfo;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class MicrosoftOnlineOfficeEditor implements OnlineOfficeFileEditor {

    private static final Logger logger = LoggerFactory.getLogger(MicrosoftOnlineOfficeEditor.class);

    private final Blackbox2 blackbox;

    private final MicrosoftAppsDiscoveryService microsoftAppsDiscoveryService;

    private final ExtensionConversionRegistry extensionConversionRegistry;

    private final MicrosoftAppSizeLimitsRegistry microsoftAppSizeLimitsRegistry;

    private final MicrosoftExtensionConvertSizeLimitRegistry microsoftExtensionConvertSizeLimitRegistry;

    private final OfficeAllowedPddDomainDao officeAllowedPddDomainDao;

    public MicrosoftOnlineOfficeEditor(Blackbox2 blackbox,
            MicrosoftAppsDiscoveryService microsoftAppsDiscoveryService, ExtensionConversionRegistry extensionConversionRegistry,
            MicrosoftAppSizeLimitsRegistry microsoftAppSizeLimitsRegistry,
            MicrosoftExtensionConvertSizeLimitRegistry microsoftExtensionConvertSizeLimitRegistry,
                                       OfficeAllowedPddDomainDao officeAllowedPddDomainDao)
    {
        this.blackbox = blackbox;
        this.microsoftAppsDiscoveryService = microsoftAppsDiscoveryService;
        this.extensionConversionRegistry = extensionConversionRegistry;
        this.microsoftAppSizeLimitsRegistry = microsoftAppSizeLimitsRegistry;
        this.microsoftExtensionConvertSizeLimitRegistry = microsoftExtensionConvertSizeLimitRegistry;
        this.officeAllowedPddDomainDao = officeAllowedPddDomainDao;
    }

    @Override
    public boolean isAcceptableFor(UserData user) {
        Option<String> pddDomain = user.getPdd().flatMapO(Pdd::getDomain);
        return (!user.isB2b() && !pddDomain.isPresent()) || pddDomain.filter(this::checkPddIsAcceptable).isPresent();
    }

    private boolean checkPddIsAcceptable(String domain) {
        ListF<String> domains = Cf.toList(blackbox.query().hostedDomains(domain).getHostedDomains().map(DomainInfo::flatten).<String>flatten().unique());
        return officeAllowedPddDomainDao.existsAnyOf(domains);
    }

    @Override
    public boolean isEditPossible(FileDjfsResource file, DjfsResourcePath visiblePath) {
        String extension = visiblePath.getExtensionByMpfsWay().toLowerCase();
        if (StringUtils.isBlank(extension)) {
            return false;
        }
        Option<String> convertTargetExtension = Option.empty();
        Option<String> appO = microsoftAppsDiscoveryService.getAvailableAppForEditByExtension(extension);
        if (!appO.isPresent()) {
            convertTargetExtension = extensionConversionRegistry.getO(extension).map(ExtensionConversion::getTarget);
            appO = convertTargetExtension.flatMapO(microsoftAppsDiscoveryService::getAvailableAppForEditByExtension);
        }
        if (!appO.isPresent()) {
            return false;
        }
        if (!convertTargetExtension.isPresent()) {
            return microsoftAppSizeLimitsRegistry.getO(appO.get())
                    .flatMapO(limits -> limits.getLimits().find(limit -> EDIT_ACTION.equals(limit.getAction())))
                    .map(limit -> file.getSize() <= limit.getLimit()).getOrElse(Boolean.TRUE);
        }
        return microsoftExtensionConvertSizeLimitRegistry.getO(extension).map(limit -> file.getSize() <= limit.getLimit())
                .getOrElse(Boolean.TRUE);
    }

    @Override
    public String getEditorType() {
        return "microsoft_online";
    }
}
