package ru.yandex.chemodan.app.djfs.core.legacy.formatting.office;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.user.UserData;

public class OnlineOfficeFileEditorManager {

    private final ListF<OnlineOfficeFileEditor> editors;

    public OnlineOfficeFileEditorManager(ListF<OnlineOfficeFileEditor> editors) {
        this.editors = editors;
    }

    public Option<OnlineOfficeFileEditor> getEditorForUser(UserData user) {
        return editors.find(editor -> editor.isAcceptableFor(user));
    }
}
