package ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.dao;

import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import com.mongodb.client.model.Filters;
import org.bson.BsonDocument;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.mongo3.FiltersX;
import ru.yandex.commune.mongo3.MongoCollectionX;

public class MongoOfficePddDomainDao implements OfficeAllowedPddDomainDao {

    private final MongoCollectionX<String, MongoOfficePddDomain> collection;

    public MongoOfficePddDomainDao(MongoClient mongoClient) {
        this.collection = new MongoCollectionX<>(
                mongoClient.getDatabase("office_allowed_pdd_domains")
                        .getCollection("office_allowed_pdd_domains", BsonDocument.class),
                MongoOfficePddDomain.B);
    }

    @Override
    public boolean existsAnyOf(ListF<String> domains) {
        return collection.exists(Filters.in(FiltersX.ID_FIELD, domains), ReadPreference.secondaryPreferred());
    }
}
