package ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.dao;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDao;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

public class PgOfficeAllowedPddDomainDao extends PgShardedDao implements OfficeAllowedPddDomainDao
{
    public PgOfficeAllowedPddDomainDao(PgShardedDaoContext context) {
        super(context);
    }

    @Override
    public boolean existsAnyOf(ListF<String> domains) {
        String sql = collectStats(DjfsUid.COMMON_UID) + " SELECT count(*) FROM disk.office_allowed_pdd_domains WHERE id IN (:domains)";
        return jdbcTemplate(DjfsUid.COMMON_UID).queryForInt(sql, Cf.map("domains", domains)) > 0;
    }
}
