package ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.discovery;

import lombok.Data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@Data
@BenderBindAllFields
public class MicrosoftApp {

    private static final String DEFAULT_NAME = "";

    private final String app;

    private final ListF<Action> actions;

    public static ListF<MicrosoftApp> fromXml(XmlWopiDiscovery discovery, ListF<String> appsToApply,
            ListF<String> actionsToApply)
    {
        return discovery.getNetZones().flatMap(XmlNetZone::getApps).filter(app -> appsToApply.containsTs(app.getName().getOrElse(DEFAULT_NAME)))
                .map(app -> new MicrosoftApp(
                        app.getName().getOrElse(DEFAULT_NAME),
                        getActionsFromXmlForApp(app.getActions(), actionsToApply))
                );
    }

    private static ListF<Action> getActionsFromXmlForApp(ListF<XmlAction> xmlActions, ListF<String> actionsToApply) {
        return xmlActions.filter(action -> actionsToApply.containsTs(action.getName().getOrElse("")))
                .groupBy(action -> action.getName().getOrElse(DEFAULT_NAME)).mapEntries((action, data) ->
                        new Action(action, data.filter(xmlAction -> xmlAction.getName().isPresent())
                                .map(actionXml -> new ExtensionUrl(actionXml.getExt().get(), actionXml.getUrlsrc().getOrElse("")))));
    }
}
