package ru.yandex.chemodan.app.djfs.core.lenta;

import lombok.Data;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author messiahlap
 */
@BenderBindAllFields
@Data
public class BaseMordaBlockData {

    private final String id;
    @BenderPart(strictName = true, name = "generation_type")
    private final String generationType;

    @BenderPart(strictName = true, name = "best_resource_id")
    private final String bestResourceId;
    @BenderPart(strictName = true, name = "resource_ids")
    private final ListF<String> resourceIds;

    @BenderPart(strictName = true, name = "min_date")
    private final Instant minDate;
    @BenderPart(strictName = true, name = "max_date")
    private final Instant maxDate;
    @BenderPart(strictName = true, name = "user_timezone_id")
    private final String userTimezoneId;
    @BenderPart(strictName = true, name = "mtime")
    private final Instant mtime;
    @BenderPart(strictName = true, name = "photoslice_date")
    private final Option<Instant> photosliceDate;

    public DateTime getUserMinDate() {
        return new DateTime(minDate, DateTimeZone.forID(userTimezoneId));
    }

    public DateTime getUserMaxDate() {
        return new DateTime(maxDate, DateTimeZone.forID(userTimezoneId));
    }

}
