package ru.yandex.chemodan.app.djfs.core.lenta;

import lombok.ToString;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.client.DataapiMordaBlock;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@ActionResultPojo
@BenderBindAllFields
@ToString(callSuper = true)
public class LentaBlockInfoWithTitles extends BaseMordaBlockData {

    @BenderPart(name = "title_1", strictName = true)
    public final String title1;

    @BenderPart(name = "title_2", strictName = true)
    public final Option<String> title2;

    @BenderPart(name = "photoslice_link_text", strictName = true)
    public final Option<String> photosliceLinkText;

    public LentaBlockInfoWithTitles(DataapiMordaBlock block, String title1, Option<String> title2, Option<String> photosliceLinkText) {
        super(block.getId(), block.getGenerationType(), block.getBestResourceId(), block.getResourceIds(), block.getMinDate(), block.getMaxDate(),
                block.getUserTimezoneId(), block.getMtime(), block.getPhotosliceDate());

        this.title1 = title1;
        this.title2 = title2;
        this.photosliceLinkText = photosliceLinkText;
    }
}
