package ru.yandex.chemodan.app.djfs.core.lenta;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.djfs.core.DownloadUrlGenerator;
import ru.yandex.chemodan.app.djfs.core.client.DataApiHttpClient;
import ru.yandex.chemodan.app.djfs.core.client.LentaProperties;
import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsResourceDao;
import ru.yandex.chemodan.app.djfs.core.lenta.alice.MyPhotosScenario;
import ru.yandex.chemodan.app.lentaloader.cool.utils.BlockTitlesGenerator;
import ru.yandex.chemodan.app.lentaloader.cool.utils.GeoNamesSource;
import ru.yandex.misc.parse.CommaSeparated;

/**
 * @author freyr
 */
@Configuration
public class LentaContextConfiguration {

    @Bean
    public LentaProperties lentaProperties() {
        return new LentaProperties();
    }

    @Bean
    public BlockTitlesGenerator blockTitlesGenerator() {
        // no geo data is present in djfs cool lenta realtime actions
        return new BlockTitlesGenerator(GeoNamesSource.EMPTY);
    }

    @Bean
    public CoolLentaManager coolLentaManager(DjfsResourceDao resourceDao, DataApiHttpClient httpClient,
            DownloadUrlGenerator downloadUrlGenerator, LentaProperties lentaProperties,
            BlockTitlesGenerator titlesGenerator,
            @Value("${auth.internal-tokens.lenta.block_previews}") CommaSeparated expectedInternalTokens)
    {
        return new CoolLentaManager(resourceDao, httpClient, downloadUrlGenerator,
                lentaProperties, expectedInternalTokens.list, titlesGenerator);
    }

    @Bean
    public CoolLentaActions coolLentaActions(CoolLentaManager coolLentaManager) {
        return new CoolLentaActions(coolLentaManager);
    }

    @Bean
    public MyPhotosScenario myPhotosScenario(CoolLentaManager coolLentaManager) {
        return new MyPhotosScenario(coolLentaManager);
    }
}
