package ru.yandex.chemodan.app.djfs.core.lenta;

import java.net.URI;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@ActionResultPojo
@BenderBindAllFields
public class LentaResultItemPojo {
    public final String id;
    public final String link;

    @BenderPart(name = "image_url", strictName = true)
    public final String imageUrl;

    @BenderPart(name = "title_1", strictName = true)
    public final String title1;

    @BenderPart(name = "title_2", strictName = true)
    public final Option<String> title2;

    public LentaResultItemPojo(String id, URI uri, String title1, Option<String> title2) {
        this.id = id;
        this.link = "/client/remember/" + id;
        this.imageUrl = uri.toString();
        this.title1 = title1;
        this.title2 = title2;
    }
}
