package ru.yandex.chemodan.app.djfs.core.lenta;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;


@ActionResultPojo
@BenderBindAllFields
public class LentaResultListPojo {
    @BenderPart(name = "empty", strictName = true)
    public final boolean isEmpty;

    @BenderPart(name = "all_photos_link", strictName = true)
    public final Option<String> allPhotosLink;

    @BenderPart(name = "gallery_tail_link", strictName = true)
    public final Option<String> galleryTailLink;

    public final Option<ListF<LentaResultItemPojo>> items;

    public LentaResultListPojo(ListF<LentaResultItemPojo> items) {
        isEmpty = items.isEmpty();

        if (isEmpty) {
            allPhotosLink = Option.empty();
            galleryTailLink = Option.empty();
            this.items = Option.empty();
        } else {
            allPhotosLink = Option.of("/client/photo");
            galleryTailLink = Option.of("/client/photo");
            this.items = Option.of(items);
        }
    }
}
