package ru.yandex.chemodan.app.djfs.core.lock;

import lombok.Builder;
import lombok.Value;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
@Value
@Builder
public class FilesystemLock implements DjfsUidSource {
    private final DjfsResourcePath path;

    @Builder.Default
    private final Option<String> lockerId = Option.empty();

    @Builder.Default
    private final Option<String> operationId = Option.empty();

    @Builder.Default
    private final Option<String> operationType = Option.empty();

    private final Instant dtime;

    @Override
    public DjfsUid getUid() {
        return path.getUid();
    }
}
