package ru.yandex.chemodan.app.djfs.core.lock;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.Sharded;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
public interface FilesystemLockDao {
    @Sharded
    void insert(FilesystemLock lock);

    @Sharded
    void setDtime(DjfsResourcePath path, Instant dtime);

    @Sharded
    boolean update(DjfsResourcePath path, String lockerId, String operationId, String operationType, Instant dtime);

    @Sharded
    ListF<FilesystemLock> find(DjfsUid uid);

    @Sharded
    Option<FilesystemLock> find(DjfsResourcePath path);

    @Sharded
    void delete(DjfsResourcePath path);

    @Sharded
    void delete(DjfsResourcePath path, String lockerId);
}
