package ru.yandex.chemodan.app.djfs.core.lock;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.djfs.core.db.DaoProxyFactory;
import ru.yandex.chemodan.app.djfs.core.db.DjfsDbContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.mongo.MongoShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;

/**
 * @author eoshch
 */
@Configuration
@Import({
        DjfsDbContextConfiguration.class,
})
public class LockContextConfiguration {
    @Bean
    public MongoFilesystemLockDao mongoFilesystemLockDao(MongoShardedDaoContext dependencies) {
        return new MongoFilesystemLockDao(dependencies);
    }

    @Bean
    public PgFilesystemLockDao pgFilesystemLockDao(PgShardedDaoContext dependencies) {
        return new PgFilesystemLockDao(dependencies);
    }

    @Bean
    @Primary
    public FilesystemLockDao filesystemLockDaoProxy(DaoProxyFactory daoProxyFactory, MongoFilesystemLockDao mongoDao,
            PgFilesystemLockDao pgDao)
    {
        return daoProxyFactory.create(FilesystemLockDao.class, pgDao);
    }

    @Bean
    public PgMigrationLockDao pgMigrationLockDao(PgShardedDaoContext dependencies) {
        return new PgMigrationLockDao(dependencies);
    }

    @Bean
    public LockManager lockManager(FilesystemLockDao filesystemLockDao, PgMigrationLockDao pgMigrationLockDao)
    {
        return new LockManager(filesystemLockDao, pgMigrationLockDao);
    }
}
