package ru.yandex.chemodan.app.djfs.core.lock;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoFilesystemLock extends DefaultObject {
    public static final MongoBenderParserSerializer<String, MongoFilesystemLock> B =
            DjfsBenderFactory.createForMongo(MongoFilesystemLock.class);

    @MongoId
    public String id;
    public String uid;
    public String key;
    public Option<Data> data = Option.empty();
    public DateTime dtime;

    public FilesystemLock to() {
        return FilesystemLock.builder()
                .path(DjfsResourcePath.cons(uid, key))
                .lockerId(data.filterMap(x -> x.locker_id))
                .operationId(data.filterMap(x -> x.oid))
                .operationType(data.filterMap(x -> x.op_type))
                .dtime(dtime.toInstant())
                .build();
    }

    public static MongoFilesystemLock from(FilesystemLock lock) {
        MongoFilesystemLock result = new MongoFilesystemLock();
        result.id = lock.getPath().getMongoId();
        result.uid = lock.getPath().getUid().asString();
        result.key = lock.getPath().getPath();
        result.dtime = lock.getDtime().toDateTime(DateTimeZone.UTC);
        if (lock.getLockerId().isPresent() || lock.getOperationId().isPresent() || lock.getOperationType().isPresent()) {
            Data data = new Data();
            data.locker_id = lock.getLockerId();
            data.oid = lock.getOperationId();
            data.op_type = lock.getOperationType();
            result.data = Option.of(data);
        }
        return result;
    }

    @BenderBindAllFields
    public static class Data {
        public Option<String> oid = Option.empty();

        @BenderPart(name = "op_type", strictName = true)
        public Option<String> op_type = Option.empty();

        @BenderPart(name = "locker_id", strictName = true)
        public Option<String> locker_id = Option.empty();
    }
}
