package ru.yandex.chemodan.app.djfs.core.logging;

import java.io.Serializable;

import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.layout.PatternLayout;

import ru.yandex.misc.net.HostnameUtils;
import ru.yandex.misc.version.AppName;

/**
 * @author eoshch
 */
public class LayoutFactory {
    public static Layout<? extends Serializable> requestsLayout(AppName applicationName) {
        String pattern = "tskv"
                + "\ttskv_format=ydisk-mpfs-requests-log"
                + "\thost=" + HostnameUtils.localHostname()
                + "\tname=%tskvX{name}"
                + "\tappname=" + applicationName.appName()
                + "\tunixtime=%d{UNIX}"
                + "\ttimestamp=%d{yyyy-MM-dd HH:mm:ss,SSS}"
                + "\ttimezone=%d{XX}"
                + "\tycrid=%ycrid"
                + "\trequest_id=%rid"
                + "\tpid=%t"
                + "\tmodule=%tskvX{module}"
                + "\tmessage=%tskvm%n";
        return PatternLayout.newBuilder().withPattern(pattern).build();
    }

    public static Layout<? extends Serializable> defaultLayout(AppName applicationName) {
        String pattern = "tskv"
                + "\ttskv_format=ydisk-mpfs-default-log"
                + "\thost=" + HostnameUtils.localHostname()
                + "\tname=mpfs.default"
                + "\tappname=" + applicationName.appName()
                + "\tunixtime=%d{UNIX}"
                + "\ttimestamp=%d{yyyy-MM-dd HH:mm:ss,SSS}"
                + "\ttimezone=%d{XX}"
                + "\tycrid=%ycrid"
                + "\trequest_id=%rid"
                + "\tpid=%t"
                + "\tmodule=%c"
                + "\tlevel=%level"
                + "\tmessage=%tskvm%tskvex%n";
        return PatternLayout.newBuilder().withPattern(pattern).build();
    }

    public static Layout<? extends Serializable> errorLayout(AppName applicationName) {
        String pattern = "tskv"
                + "\ttskv_format=ydisk-mpfs-error-log"
                + "\thost=" + HostnameUtils.localHostname()
                + "\tname=mpfs.error"
                + "\tappname=" + applicationName.appName()
                + "\tunixtime=%d{UNIX}"
                + "\ttimestamp=%d{yyyy-MM-dd HH:mm:ss,SSS}"
                + "\ttimezone=%d{XX}"
                + "\tycrid=%ycrid"
                + "\trequest_id=%rid"
                + "\tpid=%t"
                + "\tmodule=%c"
                + "\tlevel=%level"
                + "\tmessage=%tskvm%tskvex{short}%n";
        return PatternLayout.newBuilder().withPattern(pattern).build();
    }

    public static Layout<? extends Serializable> eventHistoryLayout() {
        String pattern = "tskv"
                + "\tunixtime=%d{UNIX}"
                + "\thostname=" + HostnameUtils.localHostname().split("\\.")[0]
                + "\treq_id=%ycrid"
                + "\ttskv_format=ydisk-event-history-log"
                + "\t%m%n";
        return PatternLayout.newBuilder().withPattern(pattern).build();
    }
}
