package ru.yandex.chemodan.app.djfs.core.notification;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.xiva.DiskXivaServices;
import ru.yandex.chemodan.xiva.XivaClient;
import ru.yandex.chemodan.xiva.XivaEvent;
import ru.yandex.chemodan.xiva.XivaEventRecipient;
import ru.yandex.chemodan.xiva.XivaPushMapBody;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author eoshch
 */
@ActionContainer
@RequiredArgsConstructor
public class NotificationActions {
    private final XivaClient xivaClient;

    @Path(value = "/v1/save-to-offline", methods = {HttpMethod.POST})
    public void saveToOffline(@RequestParam("uid") String rawUid,
            @RequestParam("path") String rawPath)
    {
        DjfsUid uid = DjfsUid.cons(rawUid);
        DjfsResourcePath path = DjfsResourcePath.cons(uid, rawPath);

        XivaPushMapBody body = XivaPushMapBody.consJson(Cf.map(
                "t", "save_to_offline",
                "uid", uid.asLong(),
                "file", path.getPath()));

        XivaEvent event = new XivaEvent(XivaEventRecipient.passport(uid.asLong()), "save_to_offline")
                .addTag("android").addTag("ios").withBody(body);

        xivaClient.toSingleTokenClient(DiskXivaServices.DISK_NOTIFIER).send(event);
    }

    @Path(value = "/v1/copy-to-clipboard", methods = {HttpMethod.POST})
    public void copyToClipboard(@RequestParam("uid") String rawUid,
            @RequestParam("buffer") String buffer)
    {
        DjfsUid uid = DjfsUid.cons(rawUid);

        XivaPushMapBody body = XivaPushMapBody.consJson(Cf.map(
                "t", "copy-to-clipboard",
                "uid", uid.asLong(),
                "buffer", buffer));

        XivaEvent event = new XivaEvent(XivaEventRecipient.passport(uid.asLong()), "copy-to-clipboard")
                .addTag("android").addTag("ios").withBody(body);

        xivaClient.toSingleTokenClient(DiskXivaServices.DISK_NOTIFIER).send(event);
    }

    @Path(value = "/v1/update-folder", methods = {HttpMethod.POST})
    public void updateFolder(@RequestParam("uid") String rawUid,
            @RequestParam("path") String rawPath)
    {
        DjfsUid uid = DjfsUid.cons(rawUid);
        DjfsResourcePath path = DjfsResourcePath.cons(uid, rawPath);

        XivaPushMapBody body = XivaPushMapBody.consJson(Cf.map(
                "t", "update_folder",
                "uid", uid.asLong(),
                "dir", path.getPath()));

        XivaEvent event = new XivaEvent(XivaEventRecipient.passport(uid.asLong()), "update_folder")
                .addTag("android").addTag("ios").withBody(body);

        xivaClient.toSingleTokenClient(DiskXivaServices.DISK_NOTIFIER).send(event);
    }
}
