package ru.yandex.chemodan.app.djfs.core.notification;

import java.util.concurrent.ExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.chemodan.xiva.XivaClient;
import ru.yandex.chemodan.xiva.XivaClientContextConfiguration;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

/**
 * @author eoshch
 */
@Configuration
@Import(
        XivaClientContextConfiguration.class
)
public class NotificationContextConfiguration {
    @Bean
    public EmailGenerator emailGenerator(ExecutorService executorService, CeleryTaskManager celeryTaskManager,
            Blackbox2 blackbox2)
    {
        return new EmailGenerator(executorService, celeryTaskManager, blackbox2);
    }

    @Bean
    public XivaPushGenerator xivaPushGenerator(ExecutorService executorService, CeleryTaskManager celeryTaskManager,
            Blackbox2 blackbox2)
    {
        return new XivaPushGenerator(executorService, celeryTaskManager, blackbox2);
    }

    @Bean
    public NotificationActions notificationActions(XivaClient xivaClient) {
        return new NotificationActions(xivaClient);
    }
}
