package ru.yandex.chemodan.app.djfs.core.notification;

import lombok.Data;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.util.JsonUtils;
import ru.yandex.commune.json.JsonArray;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonValue;

/**
 * @author yashunsky
 */
@Data
public class XivaData {

    private final DjfsUid uid;
    private final String pushClass;
    private final String pushTag;
    private final JsonObject rootParameters;
    private final JsonArray values;

    public MapF<String, JsonValue> toCeleryKwargs() {
        JsonUtils.JsonObjectBuilder xivaDataBuilder = JsonUtils.objectBuilder()
                .add("root", JsonUtils.objectBuilder()
                        .add("tag", pushTag)
                        .add("parameters", rootParameters)
                        .toJsonObject());

        if (!values.isEmpty()) {
            xivaDataBuilder.add("values", values);
        }

        return JsonUtils.objectBuilder()
                .add("uid", uid.asString())
                .add("class", pushClass)
                .add("xiva_data", xivaDataBuilder.toJsonObject()).toMap();
    }
}
